% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qn0.R
\name{qn0}
\alias{qn0}
\title{Mixing probability for creating new cluster}
\usage{
qn0(alpha0, w, N, M, bs, as, kstar, lambda, Yn)
}
\arguments{
\item{alpha0}{A scalar defining the parameter for the Dirichlet process prior
that controls the number of clusters (or its initial values)}

\item{w}{A scalar representing the minimum number of points in each interval between two change points}

\item{N}{A scalar representing the number of data sequences}

\item{M}{A scalar representing the number of points available for each data sequence}

\item{bs}{The hyperparameter value for the scale parameter in the inverse-gamma prior for the variance
component}

\item{as}{The hyperparameter value for the shape parameter in the inverse-gamma prior for the variance
component}

\item{kstar}{A scalar with the number maximum of change points in all clusters}

\item{lambda}{A scalar defining the parameter for the Truncate Poisson distribution
that controls the number of change points (or its initial values)}

\item{Yn}{A vector or matrix with data sequences for a cluster}
}
\value{
A numerical value representing the mixing value term used to compute the probability that the given data sequence should be a singleton cluster
}
\description{
Mixing probability for creating new cluster
}
\note{
This function is called within [gibbs_alg()]. It should not be called alone.
}
\examples{
qn0(alpha0 = 1/100, w = 10, N = 5, M = 50, bs = 1000, as = 2, kstar = 2, lambda = 2, Yn = data[,1])

}
\seealso{
[gibbs_alg()]
}
