% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{clust_cp_multi}
\alias{clust_cp_multi}
\title{Clustering multivariate times series with common changes in time}
\usage{
clust_cp_multi(
  data,
  n_iterations,
  B,
  L,
  phi,
  k_0,
  nu_0,
  S_0,
  m_0,
  q = 0.5,
  alpha_SM = 0.1,
  print_progress = TRUE,
  user_seed = 1234L
)
}
\arguments{
\item{data}{a multidimensional matrix where each element is a matrix whose rows are the observations and columns the dimensions.}

\item{n_iterations}{number of MCMC iterations.}

\item{B}{number of orders for the normalisation constant.}

\item{L}{number of split-merge steps for the proposal step.}

\item{phi, k_0, nu_0, S_0, m_0}{parameters of the integrated likelihood.}

\item{q}{probability of a split in the split-merge proposal and acceleration step.}

\item{alpha_SM}{\eqn{\alpha} for the main split-merge algorithm.}

\item{print_progress}{If TRUE (default) print the progress bar.}

\item{user_seed}{seed for random distribution generation.}
}
\value{
Function \code{clust_cp_multi} returns a list containing the following components: \itemize{
\item{\code{$clust}} a matrix where each row corresponds to the output cluster of the corresponding iteration.
\item{\code{$orders}} a multidimensional array where each slice is a matrix and represent an iteration. The row of each matrix correspond the order associated to the corresponding cluster.
\item{\code{time}} computational time in seconds.
\item{\code{$norm_vec}} a vector containing the normalisation constant computed at the beginning of the algorithm.
}
}
\description{
Clustering multivariate times series with common changes in time
}
\keyword{internal}
