#' Sample mortality data stratified by insurance products
#'
#' This is a sample data set used for demonstration purposes. They consist of two 3-dimensional arrays, one for number of deaths (\code{dxt_array_product}) and another for the the corresponding central exposures to risk (\code{Ext_array_product}).
#'
#' @docType data
#' @usage data("dxt_array_product")
#' @format A 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years) with 4 strata (products), 83 ages, and 5 years:
#' \describe{
#'   \item{Strata/Products}{Character. Names of the insurance products considered in the dataset. There are in total 4 products: \cr 
#'   \code{"ACI"}: ; \cr 
#'   \code{"DB"}: ; \cr 
#'   \code{"SCI"}: ; \cr 
#'   \code{"Annuities"}:  Note that this product contains a lot of missing values.}
#'   \item{Ages}{Numeric. Ages at claims, ranging between 18-100.}
#'   \item{Years}{Numeric. Years at claims, spanning years 2016-2020.}
#' }
#' @keywords datasets
#' @rdname data_array_product
#' @examples
#' ##Load death data
#' data("dxt_array_product")
#' str(dxt_array_product)
#' head(dxt_array_product)
#' 
#' #extracting a subset of the data (3 products, ages 35-65, years 2016-2020)
#' dxt_array_product[c("ACI","DB","SCI"),as.character(35:65),as.character(2016:2020)]
#' 
"dxt_array_product"