% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesMultMeta.R
\name{MC_ranks}
\alias{MC_ranks}
\title{Computes the ranks within the pooled draws of Markov chains}
\usage{
MC_ranks(MC)
}
\arguments{
\item{MC}{An \eqn{N \times M} matrix with N draws in each of M constructed
Markov chains.}
}
\value{
a matrix with the ranks from the MCMC procedure
}
\description{
The function computes the ranks within the pooled draws of Markov
chains. Average ranks are used for ties.
}
\examples{
dataREM<-mvmeta::hyp
# Observation matrix X
X<-t(cbind(dataREM$sbp,dataREM$dbp))
p<-nrow(X) # model dimension
n<-ncol(X) # sample size
# Matrix U
U<-matrix(0,n*p,n*p)
for (i_n in 1:n) {
  Use<-diag(c(dataREM$sbp_se[i_n],dataREM$dbp_se[i_n]))
  Corr_mat<-matrix(c(1,dataREM$rho[i_n],dataREM$rho[i_n],1),p,p)
  U[(p*(i_n-1)+1):(p*i_n),(p*(i_n-1)+1):(p*i_n)]<- Use\%*\%Corr_mat\%*\%Use
}
# Generating M Markov chains for mu_1
M<-4 # number of chains
MC <-NULL
for (i in 1:M) {
chain <-  BayesMultMeta(X, U, 1e2, burn_in = 1e2,
                          likelihood = "t", prior="jeffrey",
                          algorithm_version = "mu",d=3)
  MC<- cbind(MC,chain$mu[1,])
}
ranks<-MC_ranks(MC)
id_chain <- 1
hist(ranks[,id_chain],breaks=25,prob=TRUE, labels = FALSE, border = "dark blue",
  col = "light blue", main = expression("Chain 1,"~mu[1]), xlab = expression(),
  ylab = expression(),cex.axis=1.2,cex.main=1.7,font=2)

}
