% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdMeta.R
\name{ssdMeta}
\alias{ssdMeta}
\title{Sample size determination for replication success based on
    meta-analytic significance}
\usage{
ssdMeta(level, dprior, power, searchInt = c(0, 10))
}
\arguments{
\item{level}{Significance level for the replication effect estimate
(one-sided and in the same direction as the original effect estimate)}

\item{dprior}{Design prior object}

\item{power}{Desired probability of replication success}

\item{searchInt}{Interval for numerical search over replication standard
errors}
}
\value{
Returns an object of class \code{"ssdRS"}. See \code{\link{ssd}} for
    details.
}
\description{
This function computes the standard error required to achieve
    replication success with a certain probability and based on statistical
    significance of the fixed-effects meta-analytic effect estimate obtained
    from combining original and replication effect estimates.
}
\examples{
## specify design prior
to1 <- 2
so1 <- 1
dprior <- designPrior(to = to1, so = so1, tau = 0.25, sp = Inf)
ssdMeta(level = 0.025^2, dprior = dprior, power = 0.95)

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\author{
Samuel Pawel
}
