% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLE_Reg.R
\name{BLE_Reg}
\alias{BLE_Reg}
\title{General BLE case}
\source{
\url{https://www150.statcan.gc.ca/n1/en/catalogue/12-001-X201400111886}
}
\usage{
BLE_Reg(ys, xs, a, R, Vs, x_nots, V_nots)
}
\arguments{
\item{ys}{response variable of the sample}

\item{xs}{explicative variable of the sample}

\item{a}{vector of means from Beta}

\item{R}{covariance matrix of Beta}

\item{Vs}{covariance of sample errors}

\item{x_nots}{values of X for the individuals not in the sample}

\item{V_nots}{covariance matrix of the individuals not in the sample}
}
\value{
A list containing the following components: \itemize{
\item \code{est.beta} - BLE of Beta
\item \code{Vest.beta} - Variance associated with the above
\item \code{est.mean} - BLE of each individual not in the sample
\item \code{Vest.mean} - Covariance matrix associated with the above
\item \code{est.tot} - BLE for the total
\item \code{Vest.tot} - Variance associated with the above
}
}
\description{
Calculates the Bayes Linear Estimator for Regression models (general case)
}
\examples{
xs <- matrix(c(1,1,1,1,2,3,5,0),nrow=4,ncol=2)
ys <- c(12,17,28,2)
x_nots <- matrix(c(1,1,1,0,1,4),nrow=3,ncol=2)
a <- c(1.5,6)
R <- matrix(c(10,2,2,10),nrow=2,ncol=2)
Vs <- diag(c(1,1,1,1))
V_nots <- diag(c(1,1,1))

Estimator <- BLE_Reg(ys, xs, a, R, Vs, x_nots, V_nots)
Estimator

}
\references{
Gonçalves, K.C.M, Moura, F.A.S and  Migon, H.S.(2014). Bayes Linear Estimation for Finite Population with emphasis on categorical data. Survey Methodology, 40, 15-28.
}
