% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockGLasso.R
\name{blockGLasso}
\alias{blockGLasso}
\title{Block Gibbs sampler function}
\usage{
blockGLasso(X, iterations = 2000, burnIn = 1000, lambdaPriora = 1,
  lambdaPriorb = 1/10, verbose = TRUE)
}
\arguments{
\item{X}{Data matrix}

\item{iterations}{Length of Markov chain after burn-in}

\item{burnIn}{Number of burn-in iterations}

\item{lambdaPriora}{Shrinkage hyperparameter (lambda) gamma distribution shape}

\item{lambdaPriorb}{Shrinkage hyperparameter (lambda) gamma distribution scale}

\item{verbose}{logical; if TRUE return MCMC progress}
}
\value{
\item{Sigma}{List of covariance matrices from the Markov chain}
\item{Omega}{List of concentration matrices from the Markov chains}
\item{Lambda}{Vector of simulated lambda parameters}
}
\description{
Blockwise sampling from the conditional distribution of a permuted column/row
for simulating the posterior distribution for the concentration matrix specifying
a Gaussian Graphical Model
}
\details{
Implements the block Gibbs sampler for the Bayesian graphical lasso
introduced in Wang (2012). Samples from the conditional distribution of a 
permuted column/row for simulating the posterior distribution for the concentration 
matrix specifying a Gaussian Graphical Model
}
\examples{
\donttest{
# Generate true covariance matrix:
s<-.9**toeplitz(0:9)
# Generate multivariate normal distribution:
set.seed(5)
x<-MASS::mvrnorm(n=100,mu=rep(0,10),Sigma=s)
blockGLasso(X=x)
}
# Same example with short MCMC chain:
s<-.9**toeplitz(0:9)
set.seed(6)
x<-MASS::mvrnorm(n=100,mu=rep(0,10),Sigma=s)
blockGLasso(X=x,iterations=100,burnIn=100)
}
\references{
Wang, H. (2012). Bayesian graphical lasso models and efficient 
posterior computation. \emph{Bayesian Analysis, 7}(4). <doi:10.1214/12-BA729> .
}
\author{
Patrick Trainor (University of Louisville)

Hao Wang
}
