% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{cal_laplacian}
\alias{cal_laplacian}
\title{Calculate Graph Laplacian Matrix}
\usage{
cal_laplacian(W, type = c("unnormalized", "normalized", "randomwalk"))
}
\arguments{
\item{W}{A square adjacency matrix (can be dense or sparse).}

\item{type}{Type of Laplacian to compute: "unnormalized", "normalized", or "randomwalk".}
}
\value{
Laplacian matrix of the same class as input.
}
\description{
Compute unnormalized, normalized, or random-walk Laplacian from an adjacency matrix.
}
\examples{
\donttest{
W <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
cal_laplacian(W, type = "normalized")
}
}
