% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceToTarget.R
\name{distanceToTarget}
\alias{distanceToTarget}
\title{Calculates distances to a target point}
\usage{
distanceToTarget(data, target, targetRadious = 0)
}
\arguments{
\item{data}{An object of class `trajectory` containing a collection of points with coordinates.}

\item{target}{A numeric vector representing the coordinates of the target point.}

\item{targetRadious}{A numeric value indicating the radius around the target point. 
Points within this radius are considered to be close to the target. Default is 0.}
}
\value{
A list containing:
\item{distance}{A numeric vector of distances from each point in `data` to the `target`.}
\item{r}{A list with two components: `start`, indicating the starting indices of contiguous segments 
of points within the target radius, and `length`, indicating the lengths of these segments.}
\item{target_radious}{The radius around the target point.}
}
\description{
Given a dataset of points, it computes the Euclidean distances from each point to a specified target point. 
The function also identifies contiguous segments of points that fall within a specified radius around the target.
}
