% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampleTrajectory.R
\name{subsampleTrajectory}
\alias{subsampleTrajectory}
\title{Subsample the points of a trajectory object and create a new trajectory}
\usage{
subsampleTrajectory(obj, step = 2)
}
\arguments{
\item{obj}{An object of class `trajectory` that contains a component `points`. The `points` component must have columns `x` 
and `y` representing the trajectory coordinates.}

\item{step}{A positive integer that defines the step size for subsampling the points. 
Default is `2`, meaning every second point will be selected.}
}
\value{
A new trajectory object created using the subsampled points and the adjusted `delta_time`.
}
\description{
This function subsamples the points of a `trajectory` object by selecting every `step`-th 
point. It then creates a new trajectory using the selected points, adjusting the `delta_time` 
accordingly.
}
