% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_Report.R
\name{BP_Report}
\alias{BP_Report}
\title{Generate a pdf report for the analyzed bone}
\usage{
BP_Report(
  bone = stop("A bone section must be provided"),
  control.plot = list(message = NULL, show.centers = TRUE, show.colors = TRUE, show.grid
    = TRUE, CI = "ML", show.legend = TRUE),
  analysis = 1,
  docx = file.path(getwd(), "report.docx"),
  pdf = file.path(getwd(), "report.pdf"),
  xlsx = file.path(getwd(), "report.xlsx"),
  author = NULL,
  title = attributes(bone)$name
)
}
\arguments{
\item{bone}{The bone image}

\item{control.plot}{A list with the parameters used for plot}

\item{analysis}{Indicate analysis name or rank that you want report}

\item{docx}{Name of Word file}

\item{pdf}{Name of pdf file}

\item{xlsx}{Name of Excel file}

\item{author}{Name indicated in the report}

\item{title}{Title of the report}
}
\value{
Nothing
}
\description{
Generate a docx, xlsx, or pdf report.\cr
In the xlsx report, the observed compactness is simply the ratio of the number
of mineralized pixels to the number of total pixels.\cr
The corrected modelled compactness is the compactness if the bone had the
same number of pixels in the centre as on the periphery So it's a compactness
that corrects for the shape of the bone.
}
\details{
BP_Report save a pdf report for the analyzed bone
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic")
 bone <- BP_FitMLCompactness(bone, analysis="logistic")
 fittedpar <- BP_GetFittedParameters(bone, analysis="logistic", 
                                     ML=TRUE, return.all = FALSE)[, "mean"]
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="flexit")
 bone <- BP_FitMLCompactness(bone, 
                fitted.parameters=c(fittedpar, K1=1, K2=1), 
                fixed.parameters=NULL, analysis="flexit")
 compare_AIC(Logistic=BP_GetFittedParameters(bone, analysis="logistic", 
                                             ML=TRUE, return.all = TRUE), 
             Flexit=BP_GetFittedParameters(bone, analysis="flexit", 
                                           ML=TRUE, return.all = TRUE))
 bone <- BP_FitMLRadialCompactness(bone, analysis="logistic")
 # Test using the change of orientation using default.angle from BP_EstimateCompactness():
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="logistic_rotation_pi")
 # With a pi rotation, the top moves to the bottom and the left moves to the right
 bone <- BP_EstimateCompactness(bone, rotation.angle=pi, analysis="logistic_rotation_pi")
 bone <- BP_FitMLRadialCompactness(bone, analysis="logistic_rotation_pi")
 # Periodic analysis
 par <- BP_GetFittedParameters(bone, analysis="logistic", ML=TRUE, return.all = FALSE)[, "mean"]
 options(mc.cores=parallel::detectCores())
 bone <- BP_FitMLPeriodicCompactness(bone, analysis="logistic", control.optim=list(trace=2), 
                                     fitted.parameters=c(par, PSin=0.001, PCos=0.001, 
                                     SSin=0.001, SCos=0.001, MinSin=0.001, MinCos=0.001, 
                                     MaxSin=0.001, MaxCos=0.001), replicates.CI=2000)
                                     
 BP_Report(bone=bone, 
           analysis=1,
           docx=NULL, 
           pdf=NULL, 
           xlsx=file.path(getwd(), "report.xlsx"), 
           author="Marc Girondot", 
           title=attributes(bone)$name)
           
 BP_Report(bone=bone, 
           analysis=1,
           docx=NULL, 
           pdf=file.path(getwd(), "report.pdf"), 
           xlsx=NULL, 
           author="Marc Girondot", 
           title=attributes(bone)$name)
           
 BP_Report(bone=bone, 
           analysis=1,
           docx=file.path(getwd(), "report.docx"), 
           pdf=NULL, 
           xlsx=NULL, 
           author="Marc Girondot", 
           title=attributes(bone)$name)
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitBayesianPeriodicCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLPeriodicCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
