% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BranchGLM-package.R
\docType{package}
\name{BranchGLM-package}
\alias{BranchGLM-package}
\title{BranchGLM: Efficient Best Subset Selection for GLMs via Branch and Bound Algorithms}
\description{
Performs efficient and scalable glm best subset selection using a novel implementation of a branch and bound algorithm. To speed up the model fitting process, a range of optimization methods are implemented in 'RcppArmadillo'. Parallel computation is available using 'OpenMP'.
}
\examples{
# Using iris data to demonstrate package usage
Data <- iris

# Fitting linear regression model
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")
Fit

# Doing branch and bound best subset selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
showprogress = FALSE, bestmodels = 10)
VS

## Plotting results
plot(VS, ptype = "variables")

}
\references{
Seedorff J, Cavanaugh JE. \emph{Assessing Variable Importance for Best
Subset Selection. Entropy. 2024; 26(9):801}. \doi{https://doi.org/10.3390/e26090801}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/JacobSeedorff21/BranchGLM}
  \item Report bugs at \url{https://github.com/JacobSeedorff21/BranchGLM/issues}
}

}
\author{
\strong{Maintainer}: Jacob Seedorff \email{jacob-seedorff@uiowa.edu}

}
\keyword{internal}
