% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CASCORE.R
\name{CASCORE}
\alias{CASCORE}
\title{Covariate Assisted Spectral Clustering on Ratios of Eigenvectors.}
\usage{
CASCORE(
  Adj,
  Covariate,
  K,
  alpha = NULL,
  alphan = 5,
  itermax = 100,
  startn = 10
)
}
\arguments{
\item{Adj}{A 0/1 adjacency matrix.}

\item{Covariate}{A covariate matrix. The rows correspond to nodes and the columns correspond to covariates.}

\item{K}{A positive integer, indicating the number of underlying communities in graph \code{Adj}.}

\item{alpha}{A numeric vector, each element of which is a tuning parameter to weigh the covariate matrix.}

\item{alphan}{The number of candidates \eqn{\alpha}. The default number is 5.}

\item{itermax}{\code{k-means} parameter, indicating the maximum number of
iterations allowed. The default value is 100.}

\item{startn}{\code{k-means} parameter. If centers is a number, how many
random sets should be chosen? The default value is 10.}
}
\value{
\item{estall}{A lavel vector}.
}
\description{
Using ratios-of-eigenvectors to detect underlying communities in networks with node covariates.
}
\details{
\emph{CASCORE} is fully established in \emph{Network-Adjusted Covariates for Community Detection}
  of Hu & Wang (2023). \emph{CASCORE} detects the latent community structure under the covariate
  assisted degree corrected stochastic block model (CADCSBM), and it allows the disagreement
  between the community structures indicated in the graph and the covariates, respectively.
  \code{K-means} is applied on the entry-wise ratios between first leading eigenvector and
  each of the other \eqn{K} leading eigenvectors of the combined matrix of the adjacency matrix
  and the covariate matrix, to reveal the underlying memberships.
}
\examples{

# Simulate the Network
n = 10; K = 2;
theta = 0.4 + (0.45-0.05)*(seq(1:n)/n)^2; Theta = diag(theta);
P  = matrix(c(0.8, 0.2, 0.2, 0.8), byrow = TRUE, nrow = K)
set.seed(2022)
l = sample(1:K, n, replace=TRUE); # node labels
Pi = matrix(0, n, K) # label matrix
for (k in 1:K){
  Pi[l == k, k] = 1
}
Omega = Theta \%*\% Pi \%*\% P \%*\% t(Pi) \%*\% Theta;
Adj = matrix(runif(n*n, 0, 1), nrow = n);
Adj = Omega - Adj;
Adj = 1*(Adj >= 0)
diag(Adj) = 0
Adj[lower.tri(Adj)] = t(Adj)[lower.tri(Adj)]
caseno = 4; Nrange = 10; Nmin = 10; prob1 = 0.9; p = n*4;
Q = matrix(runif(p*K, 0, 1), nrow = p, ncol = K)
Q = sweep(Q,2,colSums(Q),`/`)
W = matrix(0, nrow = n, ncol = K);
for(jj in 1:n) {
  if(runif(1) <= prob1) {W[jj, 1:K] = Pi[jj, ];}
  else W[jj, sample(K, 1)] = 1;
}
W = t(W)
D0 = Q \%*\% W
X = matrix(0, n, p)
N = switch(caseno, rep(100, n), rep(100, n), round(runif(n)*Nrange+ Nmin),
  round(runif(n)* Nrange+Nmin))
for (i in 1: ncol(D0)){
  X[i, ] = rmultinom(1, N[i], D0[, i])
}
CASCORE(Adj, X, 2)
}
\references{
Hu, Y., & Wang, W. (2023) \emph{Network-AdjustedCovariatesforCommunity Detection},
  \cr\url{https://arxiv.org/abs/2306.15616}\cr
}
