% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oPCA.R
\name{oPCA}
\alias{oPCA}
\title{Ordinary Principle Component Analysis.}
\usage{
oPCA(Adj, K, itermax = 100, startn = 10)
}
\arguments{
\item{Adj}{A 0/1 adjacency matrix.}

\item{K}{A positive integer, indicating the number of underlying communities in
graph \code{Adj}.}

\item{itermax}{\code{k-means} parameter, indicating the maximum number of
iterations allowed. The default value is 100.}

\item{startn}{\code{k-means} parameter. If centers is a number, how many
random sets should be chosen? The default value is 10.}
}
\value{
\item{estall}{A lavel vector.}
}
\description{
\emph{Ordinary Principle Component Analysis (oPCA)}, also known as spectral clustering
  on the adjacency matrix is a classical spectral clustering method that applies \code{k-means} on
  the first \eqn{K} leading (unit-norm) eigenvectors of the adjacency matrix of a graph.
}
\examples{

# Simulate the Network
n = 10; K = 2;
theta = 0.4 + (0.45-0.05)*(seq(1:n)/n)^2; Theta = diag(theta);
P  = matrix(c(0.8, 0.2, 0.2, 0.8), byrow = TRUE, nrow = K)
set.seed(2022)
l = sample(1:K, n, replace=TRUE); # node labels
Pi = matrix(0, n, K) # label matrix
for (k in 1:K){
  Pi[l == k, k] = 1
}
Omega = Theta \%*\% Pi \%*\% P \%*\% t(Pi) \%*\% Theta;
Adj = matrix(runif(n*n, 0, 1), nrow = n);
Adj = Omega - Adj;
Adj = 1*(Adj >= 0)
diag(Adj) = 0
Adj[lower.tri(Adj)] = t(Adj)[lower.tri(Adj)]
oPCA(Adj, 2)
}
\references{
Chung, F. R., & Graham, F. C. (1997). \emph{Spectral graph theory (Vol. 92)}.
  \emph{American Mathematical Soc..}
}
