% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdss_wf_read_skill_assignment.R
\name{cdss_wf_read_skill_assignment}
\alias{cdss_wf_read_skill_assignment}
\title{Read an assignment of taught and required skills for a set of learning objects from file and
do the whole workflow up to a surmise function on skills}
\usage{
cdss_wf_read_skill_assignment(
  filename,
  filename2 = NULL,
  filetype = "auto",
  taughtname = "Taught",
  requiredname = "Required",
  header = TRUE,
  sep = ",",
  dec = ".",
  warnonly = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filename}{Name of the file (in case of CSV files the one with TAUGHT assignments)}

\item{filename2}{Name of the CSV file with REQUIRED assignments (if applicable)}

\item{filetype}{Type of the file, allowed values are "auto", "ODS", "XLSX", and "CSV"}

\item{taughtname}{Name of the sheet with required assignment (default = "Taught")}

\item{requiredname}{Name of the sheet with required assignment (default = "Required")}

\item{header}{Boolean specifying whether the CSV-files contain a header line (default = TRUE)}

\item{sep}{Column separator for CSV files (default ",")}

\item{dec}{Decimal point character for CSV files (default ".")}

\item{warnonly}{Are non-compliant SAs allowed? (default = FALSE)}

\item{verbose}{Verbosity of compliance test (default = TRUE)}
}
\value{
List of four elements: sfs (surmise function between skills),
                               sfl (surmise function between learning objects)
                               srs (surmise relation between skills, if available; NULL otherwise)
                               srl (surmise relation between learning objectrs, if available; NULL otherwise)
}
\description{
\code{cdss_wf_read_skill_assignment} expects an ODS or XLSX file with two sheets assigning 
taught and required, respectively, skills to learning objects with two columns each. 
Alternatively, two CSV files can be specified. In the sheets/CSV files, the first
column contains the IDs of learning objects and the second row the IDs of single skills
required or taught, respectively, by this learning object.
It returns a list of two binary matrices, "taught" and "required". Each matrix has one
row per learning object and one column per skill. The cells contain a "1" if the skill
is taught or required, respectively, by the learning object and a "0" otherwise,
}
\seealso{
Other functions reading skill assignments: 
\code{\link{cdss_read_skill_assignment_csv}()},
\code{\link{cdss_read_skill_assignment_ods}()},
\code{\link{cdss_read_skill_assignment_xlsx}()}
}
\concept{functions reading skill assignments}
