% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDVineCopulaConditional.r
\name{CDVineCondListMatrices}
\alias{CDVineCondListMatrices}
\title{List of the possible C- and D- vines allowing for conditional simulation}
\usage{
CDVineCondListMatrices(data, Nx, type = "CVine-DVine")
}
\arguments{
\item{data}{An \code{N x d} data matrix.
Data of the conditioning variable(s) have to occupy the last column(s) of this matrix.}

\item{Nx}{Number of conditioning variables.}

\item{type}{Type of vine to be considered: \cr
C-Vine: "CVine" or 1; \cr
D-Vine: "DVine" or 2; \cr
Both C and D-Vine: "CVine-DVine" or "1-2" (default).}
}
\value{
Listes of matrices describing C- (\code{$CVine}) and D- (\code{$DVine}) Vines. 
Each matrix corresponds to a vine, according to the same notation used for \code{\link[VineCopula]{RVineMatrix}} 
objects (for further details about \code{\link[VineCopula]{RVineMatrix}} objects see the documentation file of the \code{VineCopula} package). 
The index \code{i} in the matrix corresponds to the variable in the i-th column of \code{data}.
}
\description{
Provides a list of the C- and D- vines which allow for conditional 
sampling, under the condition discussed in the descriprion of \code{\link{CDVineCondFit}}.
}
\examples{

# Read data
data(dataset)
data <- dataset$data[1:100,1:5]

# Define the variables Y and X. X are the conditioning variables, 
# which have to be positioned in the last columns of the data.frame
colnames(data) <- c("Y1","Y2","X3","X4","X5")

# List possible D-Vines:
ListVines <- CDVineCondListMatrices(data,Nx=3,"DVine")
ListVines$DVine

# List possible C-Vines:
ListVines <- CDVineCondListMatrices(data,Nx=3,"CVine")
ListVines$CVine

# List possible C- and D-Vines:
ListVines <- CDVineCondListMatrices(data,Nx=3,"CVine-DVine")
ListVines

}
\author{
Emanuele Bevacqua
}
\references{
Bevacqua, E., Maraun, D., Hobaek Haff, I., Widmann, M., and Vrac, M.: Multivariate statistical modelling of compound events via pair-copula constructions: analysis of floods in Ravenna (Italy), 
Hydrol. Earth Syst. Sci., 21, 2701-2723, https://doi.org/10.5194/hess-21-2701-2017, 2017.
\href{https://www.researchgate.net/publication/317414374_Multivariate_statistical_modelling_of_compound_events_via_pair-copula_constructions_Analysis_of_floods_in_Ravenna_Italy}{[link]} 
\href{https://www.hydrol-earth-syst-sci.net/21/2701/2017/hess-21-2701-2017.html}{[link]} 

Aas, K., Czado, C., Frigessi, A. and Bakken, H.: Pair-copula constructions of multiple dependence, Insurance:
Mathematics and Economics, 44(2), 182-198, <doi:10.1016/j.insmatheco.2007.02.001>, 2009. 
\href{http://www.sciencedirect.com/science/article/pii/S0167668707000194}{[link]}
}
\seealso{
\code{\link{CDVineCondFit}}
}

