% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clustering_functions.R
\name{markers_cluster_seurat}
\alias{markers_cluster_seurat}
\title{markers_cluster_seurat}
\usage{
markers_cluster_seurat(seurat_object, cluster, cell_names, number_top)
}
\arguments{
\item{seurat_object}{Seurat object as returned by
\emph{cluster_analysis_sub} or by \emph{cluster_analysis_integrate_rare}.}

\item{cluster}{Vector of length equal to the number of cells, with cluster
assignment.}

\item{cell_names}{Vector of length equal to the number of cells, with cell
names.}

\item{number_top}{Integer. Number of top marker genes to keep for each
cluster.}
}
\value{
List of three elements. The first is a vector with \emph{number_top}
marker genes for each cluster. The second is a vector with \emph{number_top}
marker genes and corresponding cluster. The third element is a vector with
all marker genes for each cluster.
}
\description{
The Seurat function \emph{FindMarkers} is used to identify general marker
for each cluster (specific cluster vs all other cluster). This list of
markers is then filtered keeping only the genes that appear as markers in a
unique cluster.
}
\seealso{
\url{https://www.rdocumentation.org/packages/Seurat/versions/4.0.1/topics/FindMarkers}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
