% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGLMsimu.functions.R
\name{forward.sel.dglm}
\alias{forward.sel.dglm}
\title{Forward Stepwise Selection for Simulated Data}
\usage{
forward.sel.dglm(dat.ana.num12.df, ouput.name = "out1.txt", num.loop = 10)
}
\arguments{
\item{dat.ana.num12.df}{A data set filled with data based on a simulation, per the procedure to generate it in the simu.inter.dat.interboth function.}

\item{ouput.name}{The name of the output file to which the results are to be saved. Defaults to 'out1.txt'.}

\item{num.loop}{The number of iterations that forward stepwise selection is performed (and hence how many variables will be in the final mean and variance models). Defaults to 10 loops.}
}
\value{
A list with mean and variance mean effects and p-values associated with the coefficients.
}
\description{
This function implements the forward stepwise variable selection procedure on the simulated data set generated in simu.inter.dat.interboth. In this function, we utilize a dummy value of "1" when initializing the model to avoid issues with a NULL value when adding variables to the model.
}
\examples{
test.data <- simu.inter.dat.interboth(n.rep = 3, n.obs.per.rep = 15, ran.seed = 1)
forward.sel.dglm(test.data)
}
