% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulationStudyFunctions.R
\name{gg.corr.plot}
\alias{gg.corr.plot}
\title{Function for plotting Pearson correlations between predicted and true subject scores within the simulation study described in CJIVE manuscript}
\usage{
gg.corr.plot(cor.dat, cols, show.legend = FALSE, text.size)
}
\arguments{
\item{cor.dat}{data frame with at least the 5 following variables:
Norm - the value of the norm for a particular subspace;
Type - the subspace for which the norm is given (i.e., joint/individual score/loading for dataset X1 or X2 (except for joint scores))
Method - the method by which the subspace was estimated, e.g. CJIVE, AJIVE, R.JIVE
JVE_1 and JVE_2 - labels describing the proportion of joint variation explained in each dataset (and typically the number of variables in dataset X2)}

\item{cols}{a vector of colors, must have length equal to the number of methods used in the simulation}

\item{show.legend}{logical (TRUE/FALSE) for whether a legend should be included in the plot. Default is FALSE}

\item{text.size}{numeric value for the font size}
}
\value{
graphical display (via ggplot2)
}
\description{
Graphically displays the center and spread of chordal norms for joint/individual subject score subspaces
}
