% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLONETv2_compute_ploidy.R
\name{compute_ploidy}
\alias{compute_ploidy}
\title{Function to compute ploidy from a beta table.}
\usage{
compute_ploidy(beta_table, max_homo_dels_fraction = 0.01,
  beta_limit_for_neutral_reads = 0.9, min_coverage = 20,
  min_required_snps = 10, library_type = "WES", n_digits = 3,
  n_cores = 1)
}
\arguments{
\item{beta_table}{data.frame formatted as the output of function
\code{\link[CLONETv2:compute_beta_table]{compute_beta_table}}}

\item{max_homo_dels_fraction}{estimated maximum proportion of genomic
segments corresponding to an homozygous deletion (default=0.01)}

\item{beta_limit_for_neutral_reads}{minimum beta value of a segment valid for
computing ploidy (default=0.90)}

\item{min_coverage}{minimum coverage of a segment valid for computing ploidy
(default=20)}

\item{min_required_snps}{minimum number of informative snps in  a segment
valid for computing ploidy (default=10)}

\item{library_type}{WES, WGS (default=WES)}

\item{n_digits}{number of digits in the output table (default=3)}

\item{n_cores}{number of available cores for computation (default=1)}
}
\value{
A data.frame with two columns: sample that corresponds to column
sample of the input beta_table, and ploidy computed
}
\description{
This function takes the beta table of a tumor sample and returns its ploidy.
}
\examples{
\donttest{
## Compute ploidy table with default parameters
pl_table_toy <- compute_ploidy(bt_toy)
}
}
\author{
Davide Prandi
}
