% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc_saltiness.R
\docType{data}
\name{saltiness}
\alias{saltiness}
\title{Saltiness data}
\format{
A data frame with 321 rows and three columns.
\describe{
\item{product}{the type of product being tested}
\item{scores}{the saltiness score. Scores of 1, 2 and 3 correspond to responses
‘not salty enough’, ‘just about right saltiness’ and ‘too salty’}
\item{participant}{the participant providing the rating}
}
}
\source{
Rayner, J. C. W. and Best, D. J. (2017)
}
\usage{
data(saltiness)
}
\description{
Three products, A, B and C, were tasted by 107 consumers who gave responses
‘not salty enough’, ‘just about right saltiness’ and ‘too salty’, which were
then scored as 1, 2 and 3. The design is randomised blocks.
}
\examples{
attach(saltiness)
CMH(treatment = product, response = scores, strata = participant,
test_OPA = FALSE, test_MS = FALSE, test_C = FALSE)
}
\references{
Rayner, J. C. W. and Best, D. J. (2017). Unconditional analogues of Cochran-Mantel-Haenszel tests. Australian & New Zealand Journal of Statistics, 59(4):485–494.
}
\keyword{RBD}
\keyword{datasets}
\keyword{saltiness}
