% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerformLogReg.R
\name{PerformLogReg}
\alias{PerformLogReg}
\title{Perform Cumulative Logistic Regression and Extract Binary Odds Ratios}
\usage{
PerformLogReg(data, formula, GroupName = NULL, upper = FALSE, confLevel = 0.95)
}
\arguments{
\item{data}{A data frame containing variables in the model}

\item{formula}{A formula specifying the model, with an ordinal
outcome on the left-hand side and one or more predictors
on the right-hand side (e.g. \code{mRS ~ group}).}

\item{GroupName}{Optional character string specifying the name
of the grouping (exposure) variable for which odds ratios are
to be extracted. If \code{NULL} (default), the first covariate
in the formula is used.}

\item{upper}{Logical; if \code{FALSE} (default), odds ratios
correspond to the probability of the outcome being less than
or equal to each cut-point. If \code{TRUE}, odds ratios are
based on the probability of being greater than or equal to
each cut-point.}

\item{confLevel}{Confidence level; default is 0.95}
}
\value{
A data frame with one row per binary cut-point. Columns are:
\describe{
\item{Label}{Text label of the cut-point (e.g. \code{"mRS <= 2"}).}
\item{OR}{Estimated odds ratio for \code{GroupName}.}
\item{lower95CI}{Lower bound of the 95\% confidence interval.}
\item{upper95CI}{Upper bound of the 95\% confidence interval.}
}
}
\description{
Fits a cumulative logistic regression model for an ordinal outcome using
\pkg{VGAM}, and extracts the estimated binary odds ratios and 95\% confidence
intervals for the specified grouping variable across all possible cutpoints
}
\details{
The function uses \code{\link[VGAM]{vglm}} with
\code{\link[VGAM]{cumulative}} family to fit an ordinal
regression model without the proportional odds assumption
(\code{parallel = FALSE}). Confidence intervals are computed
using \code{\link[stats]{confint}}; if this fails, confidence
intervals are returned as \code{NA}.
}
\examples{
if (requireNamespace("VGAM", quietly = TRUE)) {
  # Simulated data
  set.seed(123)
  dat <- data.frame(
    mRS   = factor(sample(0:3, 100, replace = TRUE), ordered = TRUE),
    group = sample(c("A", "B"), 100, replace = TRUE)
  )

  # Fit and extract odds ratios
  PerformLogReg(dat, mRS ~ group, GroupName = "group")
}

}
