% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPCAT.R
\name{poisson.sub.test}
\alias{poisson.sub.test}
\title{Perform a computational approach test (CAT).}
\usage{
poisson.sub.test(dat, contrast, M = 10000)
}
\arguments{
\item{dat}{A list. The first list element contains the Poisson data of the control group, the second list element contains the Poisson data of the first treatment group etc..}

\item{contrast}{A matrix consisting of one row and ncol=number of treatments. The values must be either 0 or 1. 1 (0) includes (excludes) the corresponding treatment from the CAT procedure. For example consider 1 control group and 4 treatment groups. For testing H0: mu_0=mu_1=mu_4 choose contrast=matrix(c(1,0,0,1),nrow = 1).}

\item{M}{The number of parametric bootstrap simulations. Defaults to M=10000.}
}
\value{
A p-value for testing one intersection hypothesis.
}
\description{
Perform a computational approach test (CAT).
}
\examples{
data(testdata)
#Extract the group names from testdata.
conc<-unique(testdata[,2])	#concentration levels of the test data
#Extract the number of treatment groups.
N=length(conc)-1
#Devide the testdata into a list where the first element contains
#the Poisson data of the control group and the following contain
#the Poisson data of the treatment groups, respectively.
dat<-list()
#Create the final list.
for(j in 1:length(conc))\{
index<-which(testdata[,2]==conc[j])
dat[[j]]<-testdata[index,]
\}
#Show the data list.
dat
#Generate the intersection hypotheses of H01: mu_0=mu_1 using the
#hypotheses function.
C=hypotheses(N)[[1]]
#Show the first intersection hypothesis.
C[1,]
#Test the first intersection hypothesis.
poisson.sub.test(dat=dat,contrast=C[1,],M=10000)
}
