% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPCAT.R
\name{poisson.test}
\alias{poisson.test}
\title{Perform the closure principle computational approach test (CPCAT) for one main hypothesis H0i: mu_0=mu_i.}
\usage{
poisson.test(Data, contrastmatrix, M = 10000)
}
\arguments{
\item{Data}{The data matrix.}

\item{contrastmatrix}{The contrasts according to the closure principle induced intersection hypotheses.}

\item{M}{The number of parametric bootstrap simulations. Defaults to M=10000.}
}
\value{
The set of p-values according to the intersection hypotheses and the maximum p-value.
}
\description{
Perform the closure principle computational approach test (CPCAT) for one main hypothesis H0i: mu_0=mu_i.
}
\examples{
#Consider a data set of one control group and 3 treatment groups
data(testdata2)
#Test the main hypothesis H0: mu_0=mu_1 using M=10000
#simulation runs
C=hypotheses(3)[[1]] #Generate the set of intersection hypotheses
#according to H0
poisson.test(testdata2,contrastmatrix=C,M=10000)
}
