% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_sim.R
\name{Agg.Sim}
\alias{Agg.Sim}
\title{Aggregation of expert's estimatives by similarity of values}
\usage{
Agg.Sim(x, min, max, s, w, b)
}
\arguments{
\item{x}{Decision matrix of expert estimatives (rows) and criteria (columns). Benefit criteria must be positive and cost criteria must be negative.}

\item{min}{Vector of minimum values in each criterion scale. For common scales to all criteria, the vector must repeat the minimum value as many times as the number of criteria.}

\item{max}{Vector of maximum values in each criterion scale. For common scales to all criteria, the vector must repeat the maximum value as many times as the number of criteria.}

\item{s}{Shape of a Beta PERT distribution, as described in the package 'mc2d'. There is no default value, however the higher the shape the higher the kurtosis of the random variable.}

\item{w}{Weights describing the expert experience in the subject matter.}

\item{b}{Beta describes the balance between the expert weights and their opinions. Beta varies in the interval [0,1]. The higher the index, the higher the importance of weights.}
}
\value{
SM are the Similarity Matrices per criterion. CDC describes the Consensus Coefficient matrix. Agg.value gives the aggregated value of expert opinions per criterion.
}
\description{
This function computes the aggregated value of different expert's estimatives, using Beta PERT distributions to randomize the decision matrix.
}
\examples{
## Expert's estimatives on four criteria
Exp.1 = c(4,7,6,8)
Exp.2 = c(4,3,6,5)
Exp.3 = c(3,8,2,9)
Exp.4 = c(6,8,9,7)
Exp.5 = c(5,9,2,4)
Exp.6 = c(7,6,5,5)
x = rbind(Exp.1,Exp.2,Exp.3,Exp.4,Exp.5) # Decision matrix
min = c(0,0,0,0) # Minimum scale values.
max = c(10,10,10,10) # Maximum scale values.
s = 4 # Shape
w = c(0.4,0.3,0.2,0.06,0.04) # Expert relevance.
b = 0.4
Agg.Sim(x,min,max,s,w,b)
}
