% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_saw_ent.R
\name{CPP.SAW.Entropy}
\alias{CPP.SAW.Entropy}
\title{CPP by weighted sum, with weights computed from Shannon entropy.}
\usage{
CPP.SAW.Entropy(x)
}
\arguments{
\item{x}{Decision matrix of Alternatives (rows) and Criteria (columns). Benefit criteria must be positive and cost criteria must be negative.}
}
\value{
Weights by entropy.PMax are the joint probabilities of each alternative being higher than the others, per criterion. CPP returns the alternatives' scores by weighted sum, indicating the preference ranks for decisionmaking.
}
\description{
This function computes the CPP-SAW, using Normal distributions to randomize the decision matrix and weights defined by entropy. The CPP-SAW Entropy is used to evaluate alternatives by weighted sum.
}
\examples{
## Decision matrix.
Alt.1 = c(2,30,86,-5)
Alt.2 = c(4,26,77,-12)
Alt.3 = c(3,22,93,-4)
Alt.4 = c(6,34,65,-10)
Alt.5 = c(5,31,80,-8)
Alt.6 = c(6,29,79,-9)
Alt.7 = c(8,37,55,-15)
Alt.8 = c(10,21,69,-11)
x = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5,Alt.6,Alt.7,Alt.8)
CPP.SAW.Entropy(x)
}
\references{
Sant'Anna, Annibal P. (2015). Probabilistic Composition of Preferences: Theory and Applications, Springer.
}
