% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.rates.R
\name{sample.basic.models.joint}
\alias{sample.basic.models.joint}
\title{Jointly samples speciation and extinction trajectories through time, with noise.}
\usage{
sample.basic.models.joint(
  times,
  p.delta,
  lambda0,
  mu0 = NULL,
  MRF.type = "HSMRF",
  beta.param = c(0.3, 0.3),
  mu0.median = 0.1,
  mu0.logsd = 1.17481,
  mrf.sd.scale = 1,
  min.lambda = 0,
  min.mu = 0,
  max.lambda = 10,
  max.mu = 10,
  min.p = -0.05,
  max.p = 1.05
)
}
\arguments{
\item{times}{the time knots}

\item{p.delta}{The The pulled diversification rate function (measured in time before present).}

\item{lambda0}{The speciation rate at present.}

\item{mu0}{The extinction rate at present, otherwise drawn randomly.}

\item{MRF.type}{"HSMRF" or "GMRF", type for stochastic noise.}

\item{beta.param}{Parameters of the Beta distribution used for}

\item{mu0.median}{When not specified, extinction rate at present is drawn from a lognormal distribution with this median.}

\item{mu0.logsd}{When not specified, extinction rate at present is drawn from a lognormal distribution with this sd}

\item{mrf.sd.scale}{scale the sd of the mrf process up or down. defaults to 1.0}

\item{min.lambda}{The minimum speciation rate (rescaling done after after drawing rates).}

\item{min.mu}{The minimum extinction rate (rescaling done after after drawing rates).}

\item{max.lambda}{The maximum speciation rate (rescaling done after after drawing rates).}

\item{max.mu}{The maximum extinction rate (rescaling done after after drawing rates).}

\item{min.p}{The lower bound of parameter p's trajectory.}

\item{max.p}{The upper bound of parameter p's trajectory.}
}
\value{
Speciation or extinction rate at a number of timepoints.
}
\description{
Jointly samples speciation and extinction trajectories through time, with noise.
}
\examples{
data("primates_ebd")

l <- approxfun(primates_ebd[["time"]], primates_ebd[["lambda"]])
mu <- approxfun(primates_ebd[["time"]], primates_ebd[["mu"]])
times <- primates_ebd[["time"]]

model <- create.model(l, mu, times)

sample.joint.rates <- function(n) {
  sample.basic.models.joint(times = times, 
                            p.delta = model$p.delta,  
                            beta.param = c(0.5,0.3),  
                            lambda0 = l(0.0),  
                            mu0.median = mu(0.0))
}

joint.samples <- sample.congruence.class(model = model, 
                                         num.samples = 40, 
                                         rate.type = "joint", 
                                         sample.joint.rates = sample.joint.rates)

joint.samples
}
