% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkProfile.R
\name{checkProfile}
\alias{checkProfile}
\title{Verify position of ring transitions of a density profile}
\usage{
checkProfile(profile_with_borders, totRings)
}
\arguments{
\item{profile_with_borders}{xRing profile with transitions between rings located}

\item{totRings}{Total number of rings of the disk}
}
\value{
xRing profile with corrected ring location
}
\description{
Verify position of ring transitions of a density profile
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
image_info <- getImageInfo(hdr = hdr_df)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens,
                          n_segments = 12,
                          pixel = TRUE,
                          toPlot = FALSE)

endPath <- c(472, 284)

densPath <- extractProfile(im_dens,
                           image_info,
                           pith_coord,
                           endPath,
                           k = 2, r = 5,
                           threshold = 0.002)

newPath <- checkProfile(densPath, 26)
}
