% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grayToDensity.R
\name{grayToDensity}
\alias{grayToDensity}
\title{Convert from 8bit gray scale to density}
\usage{
grayToDensity(im, a = -0.1321, b = 0.01834)
}
\arguments{
\item{im}{Matrix of CT scan image in 8bit gray scale}

\item{a}{Intercept of the calibration curve}

\item{b}{Slope of the calibration curve}
}
\value{
Matrix of density values
}
\description{
Convert from 8bit gray scale to density
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
range(im_8bit)

im_dens <- grayToDensity(im_8bit)
range(im_dens)

}
