% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reductions.R
\docType{class}
\name{Chain-class}
\alias{Chain-class}
\alias{.Chain}
\alias{as.character,Chain-method}
\alias{accepts,Chain,Problem-method}
\alias{perform,Chain,Problem-method}
\alias{invert,Chain,SolutionORList,list-method}
\title{The Chain class.}
\usage{
\S4method{as.character}{Chain}(x)

\S4method{accepts}{Chain,Problem}(object, problem)

\S4method{perform}{Chain,Problem}(object, problem)

\S4method{invert}{Chain,SolutionORList,list}(object, solution, inverse_data)
}
\arguments{
\item{x, object}{A \linkS4class{Chain} object.}

\item{problem}{A \linkS4class{Problem} object to check.}

\item{solution}{A \linkS4class{Solution} or list.}

\item{inverse_data}{A list that contains the data encoding the original problem.}
}
\description{
This class represents a reduction that replaces symbolic parameters with
their constraint values.
}
\section{Methods (by generic)}{
\itemize{
\item \code{accepts(object = Chain, problem = Problem)}: A problem is accepted if the sequence of reductions is valid. In particular, the i-th reduction must accept the output of the i-1th
reduction, with the first reduction (self.reductions[0]) in the sequence taking as input the supplied problem.

\item \code{perform(object = Chain, problem = Problem)}: Applies the chain to a problem and returns an equivalent problem.

\item \code{invert(object = Chain, solution = SolutionORList, inverse_data = list)}: Performs the reduction on a problem and returns an equivalent problem.

}}
