% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVP.R
\name{CVP}
\alias{CVP}
\title{Parallel Cross Validation}
\usage{
CVP(X = NULL, lam = 10^seq(-2, 2, 0.2), diagonal = FALSE, tol = 1e-04,
  maxit = 10000, adjmaxit = NULL, K = 5, crit.cv = c("loglik", "AIC",
  "BIC"), start = c("warm", "cold"), cores = 1, trace = c("progress",
  "print", "none"), ...)
}
\arguments{
\item{X}{nxp data matrix. Each row corresponds to a single observation and each column contains n observations of a single feature/variable.}

\item{lam}{positive tuning parameters for elastic net penalty. If a vector of parameters is provided, they should be in increasing order. Defaults to grid of values \code{10^seq(-2, 2, 0.2)}.}

\item{diagonal}{option to penalize the diagonal elements of the estimated precision matrix (\eqn{\Omega}). Defaults to \code{FALSE}.}

\item{tol}{convergence tolerance. Iterations will stop when the average absolute difference in parameter estimates in less than \code{tol} times multiple. Defaults to 1e-4.}

\item{maxit}{maximum number of iterations. Defaults to 1e4.}

\item{adjmaxit}{adjusted maximum number of iterations. During cross validation this option allows the user to adjust the maximum number of iterations after the first \code{lam} tuning parameter has converged. This option is intended to be paired with \code{warm} starts and allows for 'one-step' estimators. Defaults to NULL.}

\item{K}{specify the number of folds for cross validation.}

\item{crit.cv}{cross validation criterion (\code{loglik}, \code{AIC}, or \code{BIC}). Defaults to \code{loglik}.}

\item{start}{specify \code{warm} or \code{cold} start for cross validation. Default is \code{warm}.}

\item{cores}{option to run CV in parallel. Defaults to \code{cores = 1}.}

\item{trace}{option to display progress of CV. Choose one of \code{progress} to print a progress bar, \code{print} to print completed tuning parameters, or \code{none}.}

\item{...}{additional arguments to pass to \code{glasso}.}
}
\value{
returns list of returns which includes:
\item{lam}{optimal tuning parameter.}
\item{min.error}{minimum average cross validation error (cv.crit) for optimal parameters.}
\item{avg.error}{average cross validation error (cv.crit) across all folds.}
\item{cv.error}{cross validation errors (cv.crit).}
}
\description{
Parallel implementation of cross validation.
}
\keyword{internal}
