% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CWT.R
\name{cwt}
\alias{cwt}
\title{Continuous Wavelet Transform}
\usage{
cwt(t, scales, variance = 1, summed_wavelet = FALSE, threads = 1L)
}
\arguments{
\item{t}{A \code{data.table}, \code{matrix}, or \code{numeric} vector where
columns or values represent time (i.e., bands) and rows samples (i.e., pixels).
Remember the transformation assume that columns or values are evenly spaced
though time (i.e., bands at equal to sampling interval).}

\item{scales}{A positive \code{numeric} vector describing the scales to
compute. The minimum scale (i.e., scales = 1) is equal to sampling interval
between columns.}

\item{variance}{A positive \code{numerber} describing the variance of the
Gaussian PDF used to scale. Default \code{variance = 1}.}

\item{summed_wavelet}{If \code{TRUE}, it returns the sum of scales.
If \code{FALSE}, each scale is returned.}

\item{threads}{An \code{integer} specifying the number of threads to use.
Experiment to see what works best for your data on your hardware.}
}
\value{
If \code{summed_wavelet = TRUE}, it returns a \code{data.table} where
columns are the sum of wavelet scales. If \code{summed_wavelet = FALSE}, it
returns an \code{array} (i.e., time, samples, and scales).
}
\description{
Compute a 1D continuous wavelet transformation using 2st order
derivative Gaussian wavelet.
}
\examples{

time_series <- sin(seq(0, 20 * pi, length.out = 100))

# Using a numeric vector

cwt(t = time_series,
    scales = c(1, 2, 3, 4, 5),
    summed_wavelet = FALSE)

cwt(t = time_series,
    scales = c(1, 2, 3, 4, 5),
    summed_wavelet = TRUE)

# Using a matrix

times <- 100
frame <- matrix(rep(time_series, times),
                nrow = times,
                byrow = TRUE)

cwt(t = frame,
    scales = c(1, 2, 3, 4, 5),
    summed_wavelet = FALSE)

cwt(t = frame,
    scales = c(1, 2, 3, 4, 5),
    summed_wavelet = TRUE)

}
\author{
J. Antonio Guzmán Q.
}
