% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Log_Normal_Formula.R
\name{Log_Normal_Formula}
\alias{Log_Normal_Formula}
\title{Log-Normal CDF Equation Formula}
\usage{
Log_Normal_Formula(concentration, shape_location, scale)
}
\arguments{
\item{concentration}{The vector of concentration values for a selected pesticide,
that has a Log Normal shaped species sensitivity distribution,
to run the equation on.}

\item{shape_location}{The mu/location value for the Log Normal equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}

\item{scale}{The sigma/scale value for the Log Normal equation for the selected pesticide.
These can be found in the "pesticide_info" data frame provided in this package.
If you are including other pesticides you will need to append them with their
respective distribution variables to the "pesticide_info" table.}
}
\value{
a numeric vector
}
\description{
Log-Normal CDF Equation Formula
}
\examples{
LogN_pesticide_concentrations <- c(0.000000001, 0.5, 2.7, 11)
Log_Normal_Formula(concentration = LogN_pesticide_concentrations,
shape_location = 0.23, scale = 1.3)
}
