% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treat_LORs.R
\name{treat_LORs}
\alias{treat_LORs}
\title{Treat a single observations LORs}
\usage{
treat_LORs(
  sample_data,
  pesticide_info = CalcThemAll.PRM::pesticide_info,
  treatment_method = "Zero"
)
}
\arguments{
\item{sample_data}{A single observation containing a concentration value for each
pesticide being used in the metric. LOR values should be in "<0.05" format and
no values should be empty "".}

\item{pesticide_info}{The reference table which contains all relevant information
for calculations. It is recommended that the "pesticide_info" dataset included in
this package be used and if you wish to include more or less pesticides you can
appended them with the relevant information to this table. If you are creating
your own table you must ensure that the pesticide name column is title "pesticides"
and the relative LOR replacement column is "relative_LOR" for the function to run.}

\item{treatment_method}{Select how to treat the LOR values with either "WQI"
representing the Queensland Department of Environment & Science Water Quality
Monitoring & Investigations team's method for replacing LORs or "Zero" which
replaces them with a negligible numeric value. Zero is the default here as this
function on its own only treats a single observation and therefore the first
detection in the WQI method cannot be used.}
}
\value{
returns the provided data set with the first row's LOR values treated.
}
\description{
Treat a single observations LORs
}
\examples{
first_sample <- Canto_pesticides[1,] #this selects only the first row (sample)
LOR_treated_first_sample <- treat_LORs(sample_data = first_sample,
pesticide_info = CalcThemAll.PRM::pesticide_info, treatment_method = "Zero")
print(LOR_treated_first_sample)
}
