% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Dosepoint.R
\name{modify_Dosepoint}
\alias{modify_Dosepoint}
\title{Modify Dosepoint in PML models}
\usage{
modify_Dosepoint(
  PMLParametersSets,
  DosepointName,
  tlag,
  bioavail,
  duration,
  rate,
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{DosepointName}{A character string giving the name of the Dosepoint.}

\item{tlag}{An optional parameter for the time lag. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{bioavail}{An optional parameter for bioavailability. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{duration}{An optional parameter for the duration of infusion. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{rate}{An optional parameter for the rate of infusion. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{PMLStructures}{Character or character vector specifying names of PML
structures in which the dosepoint statement will be modified. For the
naming convention of PMLStructures, see Details section of
\code{\link[=get_PMLParametersSets]{get_PMLParametersSets()}}.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Modify Dosepoint in PML models
}
\details{
This function can only be used to modify the structural parameters
in the built-in models (i.e., created using either \code{create_ModelEmax()} or
\code{create_ModelPK()}).
}
\examples{
PMLParametersSets <-
  get_PMLParametersSets(CompartmentsNumber = c(1, 2, 3))
# update structural paramter type
PMLParametersSetsVMod <-
 modify_Dosepoint(PMLParametersSets,
            DosepointName = "A1",
            tlag = StParm(StParmName = "Tlag",
                          State = "Searched"))

}
\seealso{
\code{\link[=list_Dosepoints]{list_Dosepoints()}}, \code{\link[=add_Dosepoint]{add_Dosepoint()}}

Functions used for Dosepoint specification: 
\code{\link{Dosepoint}()},
\code{\link{add_Dosepoint}()},
\code{\link{create_ModelPK}()}
}
\concept{Dosepoints}
