create_data_ind <-
  function(d1,
           stnames,
           catcovNames,
           contcovNames,
           rnames,
           optionalUnits,
           unitsPresent) {
    data_ind <-
      tibble::tibble(
        table = "nlme",
        col = colnames(d1),
        type = NA_character_,
        label = NA_character_,
        units = NA_character_
      )

    data_ind <-
      data_ind %>%
      dplyr::mutate(
        type = dplyr::case_when(
          .$col == "ID" ~ "id",
          .$col == "DV" ~ "dv",
          .$col == "IVAR" ~ "idv",
          .$col == "OCC" ~ "occ",
          .$col == "ObsName" ~ "dvid",
          .$col == "AMT" ~ "amt",
          .$col == "Amount" ~ "amt",
          .$col == "MDV" ~ "mdv",
          .$col == "EVID" ~ "evid",
          .$col == "IPRED" ~ "ipred",
          .$col == "PRED" ~ "pred",
          .$col %in% c(
            "RES",
            "WRES",
            "CWRES",
            "IWRES",
            "EWRES",
            "NPDE",
            "IRES",
            "CRES",
            "PCWRES"
          ) ~ "res",
          .$col %in% unlist(stnames) ~ "param",
          .$col %in% unlist(catcovNames) ~ "catcov",
          .$col %in% unlist(contcovNames) ~ "contcov",
          .$col %in% unlist(rnames) ~ "eta"
        )
      )

    data_ind <- add_unitsdata_ind(data_ind, optionalUnits, unitsPresent)

    data_ind$type[is.na(data_ind$type)] <- "na"

    data_ind
  }
