sort_dataID <- function(data, IDcol) {
  # sorting ids
  idColumn <- data$index[[1]]$col[data$index[[1]]$type == "id"]
  idsToSort <- data$data[[1]][, idColumn][[1]]

  # if we can convert to numeric IDs - sort in numeric manner
  if (all(.is_numeric_vector(unique(idsToSort)))) {
    data$data[[1]][, idColumn][[1]] <-
      factor(idsToSort, levels = sort(unique(as.numeric(idsToSort))))
    col_to_factor <- colnames(data$data[[1]]) %in%
      data$index[[1]]$col[data$index[[1]]$type %in% c("catcov", "occ", "dvid")]
  } else if (length(IDcol) > 1) {
    # convert to numeric numeric id values in case of multiple IDs
    # then arrange by all ID columns
    inputToOrder <-
      data$data[[1]] %>%
      dplyr::mutate(dplyr::across(
        c(!!!IDcol &
            dplyr::where(
              all(.is_numeric_vector(unique(
                dplyr::cur_column()
              )))
            )),
        as.numeric
      )) %>%
      dplyr::arrange(!!!IDcol)

    data$data[[1]][, idColumn][[1]] <-
      factor(idsToSort, levels = unique(inputToOrder[[idColumn]]))
    col_to_factor <- colnames(data$data[[1]]) %in%
      data$index[[1]]$col[data$index[[1]]$type %in% c("catcov", "occ", "dvid")]
  } else {
    col_to_factor <- colnames(data$data[[1]]) %in%
      data$index[[1]]$col[data$index[[1]]$type %in% c("catcov", "id", "occ", "dvid")]
  }

  data$data[[1]] <- dplyr::mutate(
    data$data[[1]],
    dplyr::across(
      colnames(data$data[[1]])[col_to_factor],
      as.factor
    )
  )

  data
}
