% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumawardscurve.R
\name{cumawardscurve}
\alias{cumawardscurve}
\title{Cumulative awards curve}
\usage{
cumawardscurve(E, d, Rule = PRO, Rules, col = NULL, legend = TRUE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{Rule}{Principal Rule: AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud. By default, \code{Rule = PRO}.}

\item{Rules}{The rules: AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud.}

\item{col}{The colours. If \code{col = NULL} then the sequence of default colours is:
c("red", "blue", "green", "yellow", "pink","orange", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{legend}{A logical value. The colour legend is shown if \code{legend = TRUE}.}
}
\value{
The graphical representation of the cumulative curves of a rule (or several rules) for a claims problem.
}
\description{
The graphical representation of the cumulative curves of a rule (or several rules) with respect to a given rule, for a claims problem.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{\sum_{i \in N} d_i\ge E}.

Rearrange the claims from small to large, \eqn{0 \le d_1 \le...\le d_n}.
The cumulative curve allows us
to compare the division recommended by a specific rule \eqn{\mathcal{R}} with the division the division recommended by another specific rule \eqn{\mathcal{S}}.

The cumulative awards curve of a rule \eqn{\mathcal{S}} with respect of a rule \eqn{\mathcal{R}} for the claims problem \eqn{(E,d)} is the polygonal path connecting the \eqn{n+1} points
\deqn{(0,0), \Bigl(\frac{\mathcal{R}_1}{E},\frac{\mathcal{S}_1}{E}\Bigr),\dots,\Bigl(\frac{\sum_{i=1}^{n-1}\mathcal{R}_i}{E},\frac{\sum_{i=1}^{n-1}\mathcal{S}_i}{E}\Bigr),(1,1).}

The cumulative awards curve fully captures the Lorenz ranking of rules:
if a rule \eqn{\mathcal{R}} Lorenz-dominates a rule \eqn{\mathcal{S}} then, for each claims problem, the cumulative curve of \eqn{\mathcal{R}}
lies above the cumulative curve of \eqn{\mathcal{S}}.
If \eqn{\mathcal{R} = \text{PRO}}, the cumulative curve coincides with the cumulative claims-awards curve.
}
\examples{
E=10
d=c(2,4,7,8)
Rule=PRO
Rules=c(AA,RA,Talmud,CEA,CEL)
cumawardscurve(E,d,Rule,Rules)
}
\references{
Lorenz, M. O. (1905). Methods of measuring the concentration of wealth. Publications of the American statistical association 9(70), 209-219.

Mirás Calvo, M.Á., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez Rodríguez, E. (2023). Deviation from proportionality and Lorenz-domination for claims problems. Review of Economic Design 27, 439-467.
}
\seealso{
\link{allrules}, \link{deviationindex}, \link{giniindex}, \link{indexgpath}, \link{lorenzcurve}, \link{lorenzdominance}.
}
