% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathawards.R
\name{pathawards}
\alias{pathawards}
\title{The path of awards for two claimants}
\usage{
pathawards(d, claimants, Rule, col = "red", points = 201)
}
\arguments{
\item{d}{The vector of claims.}

\item{claimants}{Two claimants.}

\item{Rule}{The rule: AA, APRO, CE, CEA, CEL, AV, DT, MO, PIN, PRO, RA, Talmud, RTalmud.}

\item{col}{The colour.}

\item{points}{The number of values of the endowment to draw the path.}
}
\value{
The graphical representation of the path of awards of a rule for the given claims and a pair of claimants.
}
\description{
This function returns the graphical representation of the path of awards of any rule for a claims vector and a pair of claimants.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{d\in \mathbb{R}_+^N} a vector of claims and
 denote by \eqn{D=\sum_{i \in N} d_i} the sum of claims.

The path of awards of a rule \eqn{\mathcal{R}} for two claimants \eqn{i,j\in N} is the parametric curve:
\deqn{p(E)=\Bigl\{(\mathcal{R}_i(E,d),\mathcal{R}_j(E,d))\in \mathbb{R}^2:\;E\in[0,D]\Bigr\}.}
}
\examples{
d=c(2,4,7,8)
claimants=c(1,2)
Rule=Talmud
pathawards(d,claimants,Rule)
# The path of awards of the concede-and-divide rule
pathawards(c(2,3),c(1,2),CD)
#The path of awards of the DT rule for d=(d1,d2) with d2<2d1
pathawards(c(1,1.5),c(1,2),DT,col="blue",points=1001)
#The path of awards of the DT rule for d=(d1,d2) with d2>2d1
pathawards(c(1,2.5),c(1,2),DT,col="blue",points=1001)
}
\references{
Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{pathawards3}, \link{schedrule}, \link{schedrules}, \link{verticalruleplot}.
}
