% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv05_sw_norm_test_1.R
\name{cv05_sw_norm_test_1}
\alias{cv05_sw_norm_test_1}
\title{Perform Shapiro-Wilk Normality Test}
\usage{
cv05_sw_norm_test_1(data, residue_col)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{residue_col}{The name of the column to test for normality.}
}
\value{
A data frame with the Shapiro-Wilk test results.
}
\description{
This function performs the Shapiro-Wilk test for normality on a specified variable in a dataset.
It returns a data frame with the variable name, the Shapiro-Wilk statistic, the p-value in scientific notation,
and an indication of whether the p-value is less than 0.05.
}
\examples{
data(Eq_Mic)
cv05_sw_norm_test_1(data=Eq_Mic, residue_col="Mic")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
