% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv06_sw_norm_test_2.R
\name{cv06_sw_norm_test_2}
\alias{cv06_sw_norm_test_2}
\title{Perform Shapiro-Wilk Normality Test on Two Variables}
\usage{
cv06_sw_norm_test_2(data, residue_col, residue_pct_col)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{residue_col}{The name of the first column to test for normality.}

\item{residue_pct_col}{The name of the second column to test for normality.}
}
\value{
A data frame with Shapiro-Wilk test results for both variables.
}
\description{
This function performs the Shapiro-Wilk test for normality on two specified variables within a dataset.
It returns a data frame with the variables' names, Shapiro-Wilk statistics, p-values in scientific notation,
and indications of whether the p-values are less than 0.05.
}
\examples{
# assuming Eq_DAR is a predefined dataset 
Eq_DAR <- cv03_usl_unification(data = Eq_DAR,  "CleaningEvent",  "DAR",  "USL")
cv06_sw_norm_test_2(data=Eq_DAR, residue_col="DAR", residue_pct_col="DAR_Pct")
}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
