% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv24_vca_mic.R
\name{cv24_vca_mic}
\alias{cv24_vca_mic}
\title{Variance Component Analysis for Microbial Counts}
\usage{
cv24_vca_mic(data, residue_col, cleaning_event_col)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{residue_col}{The name of the column in `data` that contains the residue or microbial counts.}

\item{cleaning_event_col}{The name of the column in `data` that contains the grouping factor for cleaning events.}
}
\value{
A data frame summarizing the variance components, including within-group variance,
        between-group variance, and total variance, along with their percentages and standard deviations.
}
\description{
This function performs a variance component analysis using a mixed-effects model
with a Poisson distribution to estimate within-group and between-group variance
for microbial counts data. Assumes data is grouped by cleaning events and 
evaluates the residue or microbial counts within these groups.
}
\examples{
# Assuming `Eq_Mic` is your dataframe, `Mic` is the microbial counts column, 
# and `CleaningEvent` is the cleaning event column:
cv24_vca_mic(Eq_Mic, "Mic", "CleaningEvent")

}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
