% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv25_qbinom_ppu.R
\name{cv25_qbinom_ppu}
\alias{cv25_qbinom_ppu}
\title{Binomial Process Performance Calculation}
\usage{
cv25_qbinom_ppu(data, residue_col, cleaning_event_col, usl_col)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{residue_col}{Name of the column in `data` that contains the residue or defect counts.}

\item{cleaning_event_col}{Name of the column in `data` that groups data by cleaning event.}

\item{usl_col}{Name of the column in `data` that contains the Upper Specification Limit (USL) for each group.}
}
\value{
A data frame with the calculated Ppu and its 95% confidence interval (CI_Lower, CI_Upper),
        along with the method used ("Q-Binomial").
}
\description{
Performs a process performance calculation using binomial distribution. This includes
a bootstrap procedure to estimate the confidence interval of the Process Performance Index (Ppu).
}
\examples{
# Assuming `data` is the dataframe with columns "Residue", "CleaningEvent", and "USL":
cv25_qbinom_ppu(Eq_Mic, "Mic", "CleaningEvent", "USL")

}
\author{
Chan, Mohamed, Lou, Wendy, Yang, Xiande [xiande.yang at gmail.com]
}
