% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{dtr}
\alias{dtr}
\title{Diurnal temperature range}
\usage{
dtr(tmax, tmin, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{tmax}{daily maximum temperature, Celsius}

\item{tmin}{daily minimum temperature, Celsius}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
temperature, Celsius
}
\description{
Mean difference between TX and TN.
}
\section{Formula}{
 \deqn{DTR_j = \frac{ \sum_{ i = 1 } ^ { I } ( TX_{ ij } - TN_{ ij })} {I}}
}

\examples{
data(data_all)
dtr(tmax=data_all$tx, tmin=data_all$tn)
}
\references{
Klein Tank AMG, Zwiers FW, Zhang X. 2009. Guidelines on analysis of extremes in a changing climate in support of informed decisions for adaptation, climate data and monitoring WCDMP-No 72, WMO-TD No 1500, p 5. \url{https://www.ecad.eu/documents/WCDMP_72_TD_1500_en_1.pdf}
}
