% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{jci}
\alias{jci}
\title{Johansson Continentality Index}
\usage{
jci(data, data_names = NULL, value, na.rm = FALSE, ...)
}
\arguments{
\item{data}{daily mean temperature, Celsius}

\item{data_names}{names of each period of time}

\item{value}{lat}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}

\item{...}{further arguments passed to or from other methods}
}
\value{
index value
}
\description{
The Johansson Continentality Index is usually used for the climatic differentiation between continental and oceanic climates.
}
\section{Formula}{
 \deqn{JCI = \frac {1.7(Thm-Tcm)}{sinf}-20.4} Thm = Average temperature of the hottest month (Celsius); Tcm = Average temperature of the coldest month (Celsius); f = geographical latitude
}

\examples{
data(data_all)
jci(data = data_all$tg, value = data_all$lat)
}
\references{
Chronopoulou-Sereli A. 1996. Courses of Agricultural Meteorology.Publications Agricultural University of Athens: Athens, OH
}
