% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penman_fao_dia.R
\name{penman_fao_diario}
\alias{penman_fao_diario}
\title{FAO-56 Penman-Monteith reference evapotranspiration (ET_0)}
\usage{
penman_fao_diario(
  Tmin,
  Tmax,
  U2,
  J,
  Ra = NA,
  lat = NA,
  Rs = NA,
  tsun = NA,
  CC = NA,
  ed = NA,
  Tdew = NA,
  RH = NA,
  P = NA,
  P0 = NA,
  z = NA,
  crop = "short",
  na.rm = FALSE
)
}
\arguments{
\item{Tmin}{minimum temperature, Celsius}

\item{Tmax}{maximum temperature, Celsius}

\item{U2}{average wind, m/s at 2m}

\item{J}{day of the year}

\item{Ra}{radiation, (MJ m-2 d-1)}

\item{lat}{latitude, degrees, CRS('+proj=longlat +ellps=WGS84 +datum=WGS84')}

\item{Rs}{daily incoming solar radiation (MJ m-2 d-1)}

\item{tsun}{sunshine duration, hours}

\item{CC}{CC}

\item{ed}{actual vapour pressure}

\item{Tdew}{dew point, Celsius}

\item{RH}{relative humidity, percentage}

\item{P}{atmospheric pressure, kPa}

\item{P0}{P0}

\item{z}{mde}

\item{crop}{"short" short reference crop or "tail" tail reference crop}

\item{na.rm}{na.rm}
}
\value{
et0, mm/day
}
\description{
FAO-56 Penman-Monteith reference evapotranspiration (ET_0)
}
\keyword{internal}
