% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{export_file_external}
\alias{export_file_external}
\title{Export result of external metrics in latex.}
\usage{
export_file_external(df, path = NULL)
}
\arguments{
\item{df}{It's a dataframe that contains as a parameter a table in latex format
with the results of the external validations.}

\item{path}{It's a string with the path to a directory where a file is to be
stored in latex format.}
}
\value{
A file in Latex format with the results of the external metrics.
}
\description{
Method that exports the results of external measurements in
latex format to a file.
}
\details{
When we work in latex format and we need to create a table to export
the results, with this method we can export the results of the clustering
algorithm to latex.
}
\examples{

result = Clustering::clustering(
               df = cluster::agriculture,
               min = 4,
               max = 5,
               algorithm='gmm',
               metrics=c("Precision")
         )

Clustering::export_file_external(result)
file.remove("external_data.tex")

}
