% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkTS.R
\name{checkTS}
\alias{checkTS}
\title{Check generated timeseries}
\usage{
checkTS(TS, distbounds = c(-Inf, Inf))
}
\arguments{
\item{TS}{generated timeseries}

\item{distbounds}{distribution bounds (default set to c(-Inf, Inf))}
}
\description{
Compares generated time series sample statistics with the theoretically expected values.
}
\examples{

library(CoSMoS)

## check your generated timeseries
x <- generateTS(margdist = 'burrXII',
                margarg = list(scale = 1,
                               shape1 = .75,
                               shape2 = .25),
                acsvalue = acs(id = 'weibull',
                               t = 0:30,
                               scale = 10,
                               shape = .75),
                n = 1000, p = 30, p0 = .5, TSn = 5)

checkTS(x)

}
