% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateMTSFast.r
\name{generateMTSFast}
\alias{generateMTSFast}
\title{Faster simulation of multiple time series with approximately separable spatiotemporal
correlation structure}
\usage{
generateMTSFast(
  n,
  spacepoints,
  margdist,
  margarg,
  p0,
  distbounds = c(-Inf, Inf),
  stcsid,
  stcsarg,
  scalefactor = 1,
  anisotropyid = "affine",
  anisotropyarg = list(phi1 = 1, phi2 = 1, phi12 = 0, theta = 0)
)
}
\arguments{
\item{n}{number of fields (time steps) to simulate}

\item{spacepoints}{matrix \code{(d x 2)} of coordinates (e.g. longitude and latitude) of \code{d} spatial locations (e.g. \code{d} gauge stations)}

\item{margdist}{target marginal distribution}

\item{margarg}{list of marginal distribution arguments. Please consult the documentation of the selected marginal distribution indicated in the argument \code{margdist} for the list of required parameters}

\item{p0}{probability zero}

\item{distbounds}{distribution bounds (default set to \code{c(-Inf, Inf)})}

\item{stcsid}{spatiotemporal correlation structure ID}

\item{stcsarg}{list of spatiotemporal correlation structure arguments. Please consult the documentation of the selected spatiotemporal correlation structure indicated in the argument \code{stcsid} for the list of required parameters}

\item{scalefactor}{factor specifying the distance between the centers of two pixels (default set to 1)}

\item{anisotropyid}{spatial anisotropy ID (\code{affine} by default, \code{swirl} or \code{wave})}

\item{anisotropyarg}{list of arguments characterizing the spatial anisotropy according to the syntax of the function \code{\link{anisotropyT}}. Isotropic fields by default}
}
\description{
For more details see section 6 in Serinaldi and Kilsby (2018), and section 2.4 in
Papalexiou and Serinaldi (2020).
}
\details{
\code{\link{generateMTSFast}} provides a faster approach to multivariate simulation
compared to \code{\link{generateMTS}} by exploiting circulant embedding
fast Fourier transformation.
However, this approach is feasible only for approximately
separable target spatiotemporal correlation functions.
\code{\link{generateMTSFast}} comprises fitting and simulation in a single function.
Here, we give indicative CPU times for some settings, referring to a
Windows 10 Pro x64 laptop with Intel(R) Core(TM) i7-6700HQ CPU @ 2.60GHz,
4-core, 8 logical processors, and 32GB RAM. \cr
CPU time:\cr
d = 2500, n = 1000: ~58s \cr
d = 2500, n = 10000: ~160s \cr
d = 10000, n = 1000: ~2955s (~50min) \cr
}
\examples{
coord <- cbind(runif(4)*30, runif(4)*30)

sim <- generateMTSFast(
    n = 50,
    spacepoints = coord,
    p0 = 0.7,
    margdist ='paretoII',
    margarg = list(scale = 1,
                   shape = .3),
    stcsarg = list(scfid = "weibull",
                   tcfid = "weibull",
                   scfarg = list(scale = 20,
                                 shape = 0.7),
                   tcfarg = list(scale = 1.1,
                                 shape = 0.8))
)


}
\references{
Serinaldi, F., Kilsby, C.G. (2018). Unsurprising Surprises:
The Frequency of Record-breaking and Overthreshold Hydrological Extremes Under
Spatial and Temporal Dependence. Water Resources Research, 54(9), 6460-6487,
\doi{10.1029/2018WR023055}

Papalexiou, S.M., Serinaldi, F. (2020). Random Fields Simplified:
Preserving Marginal Distributions, Correlations, and Intermittency,
With Applications From Rainfall to Humidity. Water Resources Research, 56(2),
e2019WR026331, \doi{10.1029/2019WR026331}
}
