% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anisotropyT.R
\name{anisotropyTaffine}
\alias{anisotropyTaffine}
\title{Affine anisotropy transformation}
\usage{
anisotropyTaffine(spacepoints, phi1, phi2, phi12, theta)
}
\arguments{
\item{spacepoints}{vector of coordinates (2 x d), where d is the number of locations/grid points}

\item{phi1}{stretching parameter along the x axis}

\item{phi2}{stretching parameter along the y axis}

\item{phi12}{shear effect}

\item{theta}{rotation angle}
}
\description{
Affine anisotropy transformation.
}
\examples{

## specify coordinates
m = 25
aux <- seq(0, m - 1, length = m)
coord <- expand.grid(aux, aux)

at <- anisotropyTaffine(spacepoints = coord,
                       phi1 = 0.5,
                       phi2 = 2,
                       phi12 = 0,
                       theta = -pi/3)

## visualize transformed coordinate system
aux = data.frame(lon = at[ ,1], lat = at[ ,2], id1 = rep(1:m, each = m), id2 = rep(1:m, m))
ggplot(aux, aes(x = lon, y = lat)) +
geom_path(aes(group = id1)) +
geom_path(aes(group = id2)) +
geom_point(col = 2) +
theme_light()

}
\references{
Allard, D., Senoussi, R., Porcu, E. (2016). Anisotropy Models for
Spatial Data. Mathematical Geosciences, 48(3), 305-328, \doi{10.1007/s11004-015-9594-x}

Papalexiou, S.M., Serinaldi, F., Porcu, E. (2021). Advancing
Space-Time Simulation of Random Fields: From Storms to Cyclones and Beyond.
Water Resources Research, 57, e2020WR029466, \doi{10.1029/2020WR029466}
}
